Program SD_Int;
  Uses
    conv_u, crt, SD_ISA_U, Time_U, PIC_U;

  Const
    M_Grad = $10000/( 360 * 60 );
      N_help = 20;
  Txt_help : array[ 1 .. N_help ] of string =
  ( '  ',
    ' ணࠬ  ன⢠ SD_PC  ०   뢠 ',
    ' ',
    ' ࠬ  ப ',
    ' SD_PC [ /B### ][ /I# ][ /D# ][ /R ][ /P ][ /? ]   ',
    '   /B### -   ன⢠,',
    '            ###   祭 300, 310, 320, 330 ( 㬮砭 300) ',
    '   /I#   -   뢠 ன⢠,',
    '            #   3, 4, 5 ( 㬮砭 5) ',
    '   /D#   - 몫祭 ࠡ  ,  #   0  1 ',
    '   /R    - ந  ७ ணࠬ ன⢠ SD_PC ',
    '   /E    - 몫祭 뢮 ᮮ饭  訡 ',
    '   /P    - ⠭ 뢮  訡 ',
    '   /?    - 뢮  ࠢ ',
    '   ࠡ ணࠬ ॠ  ᫥騥   ',
    '   0, 1  - ४祭 ० 饭 ࠡ   0  1    ',
    '   P     - ४祭 ० 饭 ⠭  訡    ',
    '   E     - ४祭 ० 饭 뢮 ᮮ饭  訡',
    '   ஡-  ⥪騥 祭   ',
    '   Esc   - 襭 ࠡ ணࠬ  '

     );


  Var
    Angl_0, Angl_1 : word;	{  㣫  0  1 }
    Err_0,  Err_1  : word;	{  訡  0  1 }
    Prev_0, Prev_1 : word;	{  㣫  0  1 ।騥 }
    X        	   : word;	{ ६ ६ }
    Ch             : char;	{ ᨬ        }
    Time_B, Time_E : longint;   { ६ 砫   ࢠ    }
    Count 	   : word;      { 稪 ᫠ 祭 祭 }
    Ena_0, Ena_1   : boolean;	{ ਧ ࠧ襭 ࠡ   0  1 }
    Stop    	   : boolean;	{ ᨣ  室  ணࠬ }
    Error_Link	   : boolean;	{ ਧ 訡 裡  ன⢮ }
    Wait    	   : boolean;	{ ᨣ     }
    Ena_Err_Wait   : boolean;	{ ࠧ襭   訡   }
    Ena_Err_Disp   : boolean;	{ ࠧ襭 뢮 ᮮ饭  訡 }
    D_Rg_A, D_Rg_B : word;	{  祭  ॣ஢ Rg_A  Rg_B ன⢠ }
    D_Rg_AB        : longint absolute D_Rg_A; { ६ ᯮ㥬 Rg_A  Rg_B ன⢠ }
    Count_Err_IO   : word;	{ 稪 ᫠ 訡   }
    New_Data   	   : boolean;	{ ࠧ襭   訡   }
    Irq_N          : integer;   {   뢠  }
    Old_Mask 	   : byte;      { ஥ 祭 ᪨ 뢠  }
    Old_Int_Vect   : pointer;   { ஥ 祭  뢠  }

  Procedure SD_PC_Int; interrupt;  {  ࠡ稪 뢠  }
  Begin
    D_Rg_A := portw[ Addr_Rg_A ];  { ⥭ ॣ஢     뢠  }
    D_Rg_B := portw[ Addr_Rg_B ];
    New_Data := True;
    Clr_Int( Irq_N shr 3 );  {   뢠  ஫ 뢠  }
  End;

  Function Wait_Interrupt( Timeout :word ) : boolean;
  { 㭪  ⮢   뢠
    頥 १ True - ᫨ 뫮 뢠
    頥 १ False - ᫨ ६  ॢᨫ ⨬ }
  Var Count, X : word;
  Begin
    Count := 1;
    while ( not New_Data ) and ( Count < Timeout ) do
    begin
      X := portw[ Addr_Rg_CSR ]; {  প  1     }
      inc( Count );
    end;
    Wait_Interrupt := Count < Timeout;
  End;

  Procedure Disp_Angle;
  { 楤 祭  ⮡ࠦ  㣫 }
  Var
    New : boolean; { ਧ  祭   ࠢ  ।騬 }
    Err : byte;    {  饩 訡 ன⢠ }
    CMD_1 : word;  {   祭   1  }
  begin
    Wait := false; { ⠭ ਧ  砫쭮 ﭨ }
    New  := false;


    Err_0 := 0;
    Err_1 := 0;
    Err := 0;
    if Ena_0 then  { ᫨ ࠧ襭 ࠡ  0  }
    begin
      New_Data := false;
      portw[ Addr_Rg_A ] := 0;
      portw[ Addr_Rg_B ] := ISA_Get_Angle_pn;
	{ ।  ⥭ 祭 㣫  0
	⫮  ஭ ୮ ᨣ  祭  }

      if Wait_Interrupt( 60000 ) and   {  뢠  ⢥ ன⢠ }
	( ( ( D_Rg_B xor not ( ISA_Get_Angle_Pn ) ) and $FF00) = 0 ) then
	{ ஢ઠ ࠢ쭮  ᭮   }
      begin
	Angl_0 := D_Rg_A;
	Err    := D_Rg_B  and $00E0;  { ⤥  訡 ன⢠ }
	Err_0  := D_Rg_B  and $001F;  { ⤥ 訡 0  }
	if  trunc( Angl_0 / M_Grad ) <> Prev_0  then
	{  㣫 0    祬  1  }
	  New := true; 		      {  뢥   }
	Prev_0 := trunc( Angl_0 / M_Grad ) ;  { ࠭  0   楫   ࠢ }
      end
      else
      begin
	Writeln( ' 訡 祭 㣫 0  ' );  { 뫠 訡  }
	inc( Count_Err_IO );
	if Count_Err_IO >= 15 then
	begin
	  Stop := True;
	  Error_Link := True;	{ ਧ 訡 裡  ன⢮ }
	end;

      end;
    end;

    if Ena_1 then
    begin

      if Ena_0 then
      { ᫨ 뫮 ⥭  0 ᨭ஭஢   ᨣ,
	  1  뤠   祭   ᨭ஭樨 }
	CMD_1 := ISA_Get_Angle
      else
	{    1    ᨭ஭樥 }
	CMD_1 := ISA_Get_Angle_Pn;

      New_Data := false;
      portw[ Addr_Rg_A ] := 1;  {   }
      portw[ Addr_Rg_B ] := CMD_1;
	{ ।  ⥭ 祭 㣫  1  祭  }
      if  Wait_Interrupt( 60000 ) and {  뢠  ⢥ ன⢠ }
	( ( ( D_Rg_B xor not ( CMD_1 ) ) and $FF00) = 0 ) then

	{ ஢ઠ ࠢ쭮  ᭮   }
      begin
	Angl_1 := D_Rg_A;
	Err    := Err or ( D_Rg_B  and $00E0 );
	{ ⤥  訡 ன⢠ 
	ꥤ  १⠬  0  }
	Err_1  := D_Rg_B  and $001F;  { ⤥ 訡 1  }
	if  trunc( Angl_1 / M_Grad ) <> Prev_1  then
	{  㣫 0    祬  1  }
	  New := true; 		      {  뢥   }
	Prev_1 := trunc( Angl_1 / M_Grad );  { ࠭  1   楫   ࠢ }

      end
      else

      begin
	Writeln( ' 訡 祭 㣫 1  ' );  { 뫠 訡  }
	inc( Count_Err_IO );
	if Count_Err_IO >= 5 then
	begin
	  Stop := True;
	  Error_Link := True;	{ ਧ 訡 裡  ன⢮ }
	end;
      end;
    end;

    if New then  {     祬  1  }
    begin
      if Ena_0 then  { ࠧ襭 ࠡ 0  }
	Write   (  '  0 =', Hex_W( Angl_0 ), 'h=', Grad( Angl_0 )  )
      else
	write(  '                               ' );
      if Ena_1 then  { ࠧ襭 ࠡ 1  }
	Write   (  '     0 =', Hex_W( Angl_1 ), 'h=', Grad( Angl_1 ) );
      writeln;
    end;
    if  Ena_err_Disp and ( Err_0 <> 0 ) then { 뫠 訡   0  }
    begin
      Write( ' 訡 0 ', Hex_B( Err_0 ), ' '  );
      Disp_Err( Err_0 );  { 뢮 ஢ 訡 }
      Wait := True;
    end;

    if  Ena_err_Disp and ( Err_1 <> 0 ) then { 뫠 訡   1  }
    begin
      Write( ' 訡 1 ', Hex_B( Err_1 ), ' '  );
      Disp_Err( Err_1 ); { 뢮 ஢ 訡 }
      Wait := True;
    end;
    if Ena_err_Disp and ( Err <> 0 )   then  { 뫠 쭠 訡 ன⢠ }
    begin
      Write( '  訡 ', Hex_B( Err ), ' '   );
      Disp_Err( Err );	{ 뢮 ஢ 訡 }
      Wait := True;
    end;

    if Ena_err_Disp and Wait then  		{ 뫠 訡  }
      if Ena_Err_Wait then	{    ࠧ襭 }
      begin
	writeln( '    ' );
	Ch := readkey;
      end
      else
	writeln;

  End;

  Procedure Keyboard;
  Begin
    if keypressed then
      Ch := readkey;

    case Ch of
    '0': begin
	   Ch := 'z';
	   Ena_0 := not Ena_0;
	 end;
    '1': begin
	   Ch := 'z';
	   Ena_1 := not Ena_1;
	 end;

    'p','P': begin
	   Ch := 'z';
	   Ena_Err_Wait := not Ena_Err_Wait;
	 end;
    'e','E': begin
	   Ch := 'z';
	   Ena_Err_Disp := not Ena_Err_Disp;
	 end;


    ' ': begin
	   Prev_0 := Prev_0 or 300;
	   Prev_1 := Prev_1 or 300;

	   Ch := 'z';
	 end;
     char(27): begin
	 Stop := True;
	 end;
    end;
  End;

  Procedure Init;
  Var
    i 	: word;
    Str_par : string;
    Restart : boolean;
  Begin
    Ena_0 := true;   	{ ࠧ襭 ࠡ   0 }
    Ena_1 := true;	{ ࠧ襭 ࠡ   1 }
    Ena_Err_Wait := false; { 饭 ⠭  祭 ਧ 訡 }
    Ena_Err_Disp := true; { ࠧ襭 뢮 ᮮ饭  訡 }
    Stop := false;   	{ ᨣ 襭 ணࠬ }
    Count_Err_IO := 0;	{ 稪 ᫠ 訡   }
    Restart := false; 	{ ਧ 室  }
    Error_Link := false; { ਧ 訡 裡  ன⢮ }
    Addr_Rg_CSR :=  $300; {    㬮砭 }
    Irq_N := 5;		  {  뢠  㬮砭 }

    for i := 1 to paramcount do
	{ ࠡ⪠ ࠬ஢  ப }
    begin
      Str_par := paramstr( i );
      if Str_par[1]  = '/' then
	case Str_par[2]  of
	  'D', 'd': begin
		 if ( Str_par[3] = '0' ) then Ena_0 := false;
		 if ( Str_par[3] = '1' ) then Ena_1 := false;
	       end;
	  'P', 'p': begin
		 Ena_Err_Wait := true;
	       end;
	  'E', 'e': begin
		 Ena_Err_Disp := false;
	       end;
	  'R', 'r': begin
		 Restart := true;
	       end;
	  'B', 'b': begin
		  X := Str_2_Hex( copy( Str_par, 3, length( Str_par ) ) ) and $FFFF;
		  if ( X = $300 ) or ( X = $310 ) or
		     ( X = $320 ) or ( X = $330 ) then
		  begin
		    Addr_Rg_CSR   := X ;
		  end;
	       end;
	  'I', 'i': begin
		  if  Str_par[3] = '3' then Irq_N := 3;
		  if  Str_par[3] = '4' then Irq_N := 4;
		  if  Str_par[3] = '5' then Irq_N := 5;
	       end;

	  '?', 'h': begin
		 for X := 1 to N_help  do
		   writeln( Txt_help[ X ] );
		 writeln;
	       end

	end;
    end;
    Addr_Rg_A     := Addr_Rg_CSR + 2;
    Addr_Rg_B     := Addr_Rg_CSR + 4;
    writeln( '   SD-PC      ', Hex_W( Addr_Rg_CSR ), 'h');
    writeln( '  뢠 SD-PC = ', Irq_N );
    if Restart then
      portw[ Addr_Rg_CSR ] := $100;
    portw[ Addr_Rg_CSR ] :=  $020; { ⨥ ᨣ Reset  ⠭ 
     뢠    ॣ Rg_B  ஭ ன⢠   }
    for i := 1 to 20 do
      X := portw[ Addr_Rg_CSR ];  { 㧠  20  }

    if Irq_Set( Irq_N , @SD_PC_Int, Old_Int_Vect, Old_Mask )
    then
    begin
      writeln( '   樠 뢠 諠 ᯥ譮' );
      D_Rg_A := portw[ Addr_Rg_A ];  { ⥭ ॣ஢     뢠  }
      D_Rg_B := portw[ Addr_Rg_B ];
      Clr_Int( Irq_N shr 3 );  {   뢠  ஫ 뢠  }
    end
    else
    begin
      writeln( '   樠 뢠  㤠' );
      halt( 1 )
    end;
  End;

  Begin
    Init;
    Count := 0;
    Time_B := Get_Time_L;
    while  not Stop  do
    begin
      Keyboard;
      Disp_Angle;
      inc( Count );
      if  Count = 4000 then
      begin
	Time_E := Get_Time_L;
	Writeln( '   := ', 4000.*100/ ( Time_E - Time_B ):5:4 ,'' );
	Time_B := Time_E;
	Count := 0;
      end;
    end;
    if Error_Link then
    begin
      Writeln('    裡  ன⢮. ');
      Writeln('  ஢ ⢥⢨ ࠬ஢ ணࠬ ன ன⢠ SD-PC ');
      for X := 1 to N_help  do
	writeln( Txt_help[ X ] );
    end;

    Irq_Restore( Irq_N, Old_Int_Vect, Old_Mask );
  End.
